# MozaTemps

A Temperature Explorer for Moza Wheel Bases


---
## About

This software displays temperature graphs and wheelbase settings for Moza wheel bases.
It does this by either reading Moza's Pit House software directly,
or you can point it at an error report zip file.

When you open MozaTemps it will attempt to load data from Pit House,
and if it cannot find any it will prompt to load an error report zip.

MozaTemps divides the data into 'Sessions', and will open to the latest session,
or 'Current Session' if the wheel base is on and Pit House is running.  You can select
any previous session from the dropdown, or at the top of the list is 
'All Sessions' for a graph including all time.

The graph can be panned around and zoomed with the mouse.  If viewing the Current Session
it will pan to make new readings visible.

Above the graph is displayed the peak temperatures recorded by each sensor during the session, 
or if viewing the Current Session then current temperatures are displayed.

Moza Pit House records temperatures every thirty seconds.

---
## Wheel Base Settings

The bottom of the screen dispays wheel base settings.  The settings displayed represent the state
at the end of the Session, unless the mouse pointer is over the graph.  Pointing at anywhere on the
graph will show the settings at that point in time.  Settings changes are represented on the graph
as a vertical dotted line, and you can see those settings change as you move the mouse over the dotted lines.

The _Temperature Strategy_ setting is an exception and is represented as a dotted horizontal line
on the graph at 50°C for _Conservative_ and 60°C for _Radical_.

Settings are not available before the first time they are changed, so as you go back in time you will
see some Settings not set.  I hope to revisit this later.

If you have multiple wheels you may notice _Steering Wheel Inertia_ changing automatically when you
switch wheels, with a convenient line on the graph showing where.

---
## This Software

MozaTemps is written in C# targeting .Net Framework 4.8 using WinForms for the UI.

MozaTemps makes use of the excellent [ScottPlot](https://scottplot.net/) plotting library
 to create its temperature graph.

MozaTemps is ©2024 Robert Havens.  Let me know what you think at Robert@SilverTalon.net

MozaTemps is _Not affiliated with Moza Racing_

-----------

